#include "common.h"



/*************************************************************************************/
//**	Copyright	:	2015 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	IIC.c                                                       **
//**	Description	: 	IO ? IIC ?											**
//**	TargerBoard	: 	None														**
//**	MCU      	: 	HT67F5650													**
//**	Author   	: 	LJQ															**
//**	Date     	: 	2015/11/20													**
//**	Version  	: 	V00															**
//**	History  	:																**
/*************************************************************************************/

/*************************************************************************************/
//**	Note:
//**	1.gJeepromɡAƾڷ|sibuffҦݭn@wɶApgᰨWŪ
//** 	  @wɶA^ɪDataSheetWwA@볣OLmsC
//**	2. ոHB45B1224ɡAݦbĤGstarte[Wstop
//**	
//**	
/*************************************************************************************/
volatile u8 IIC_data[3];

/***********************************************************
**   Function : delay5us
**   INPUT    : none
**   OUTPUT   : none
**   NOTE     : 
				CLK cycle = 10us ; Sps = 100KHz  bit/s 
***********************************************************/
void delay5us()    	   
{
//---------------------------------
// MVU Sys : 9.8 Mhz   
// nop     : 0.4us	
//---------------------------------	
	_nop();
	_nop();_nop();
//	_nop();_nop();
//	_nop();_nop();_nop();_nop();_nop();
//	_nop();_nop();_nop();

}

/***********************************************************
**   Function : IIC_start
**   INPUT    : none
**   OUTPUT   : none
**   NOTE     : 
**
**   SCL:  ___|^^^^^^^^^^^^^^^^^^^^^^^|___
**   SDA:  ___|^^^^^^^^^^_______________
**            | >4.7us| >4.7us|
**   }lHG SCLqɡASDAѰqVCq				
***********************************************************/
void IIC_start()  					
{
	IIC_SDAC = OUTPUT;						
	IIC_SCLC = OUTPUT;		
	IIC_SDA  = 1;	
	delay5us();	
	IIC_SCL  = 1;
	delay5us();							
	IIC_SDA  = 0;								
	delay5us();											
}

/***********************************************************
**   Function : IIC_stop
**   INPUT    : none
**   OUTPUT   : none
**   NOTE     : 
**
**   SCL:  ___|^^^^^^^^^^^^^^^^^^^^^^^|___
**   SDA:  _______________^^^^^^^^^^|___
**            | >4.7us| >4.7us|
**   HG SCLqɡASDAѧCqVq			
***********************************************************/
void IIC_stop()  					
{
	u8 i;
	IIC_SDAC = OUTPUT;						
	IIC_SCLC = OUTPUT;	
							
	IIC_SDA  = 0;
	delay5us();
	IIC_SCL  = 1;						
	delay5us();		
	IIC_SDA  = 1;
	for(i=0;i<10;i++)
	{
		delay5us();	
	}
		
}

/***********************************************************
**   Function : IIC_respons
**   INPUT    : 0 -> ?A1 -> D?
**   OUTPUT   : none
**   NOTE     : 
**
**   SCL:  ^^^^^^^^^^^^^^^^|___
**   SDA:  ^^^^|____|^^^^^^^^^^  : ACK
**   SDA:  ^^^^^^^^^^^^^^^^^^^^  : NO_ACK    
**   qT G SCLqɡASDAѧCqVq				
***********************************************************/
u8 IIC_respons()  					
{
	 u8 i = 100;		//
	
	// IIC_SDA_PU = EN_high;
	IIC_SDAC   = INPUT;
	
	_nop();	_nop();	_nop();	_nop();
							
	IIC_SCL    = 1;						
	delay5us();	
	
	while(i--)
	{					
		if(IIC_SDA == 0)					
		{								
			IIC_SCL  = 0;
			// IIC_SDA_PU = DIS_high;
			return 1;					
		}
	}
//	IIC_SDA_PU = DIS_high;				
	return 0;							
}
/***********************************************************
**   Function : MaterAck
**   INPUT    : 
**   OUTPUT   : 
**   NOTE     : 
**
**   SCL:  ^^^^^^^^^^^^^^^^|___
**   SDA:  ^^^^|____|^^^^^^^^^^  : ACK
**   SDA:  ^^^^^^^^^^^^^^^^^^^^  : NO_ACK    
**   DT G SCLqɡASDAѧCqVq				
***********************************************************/
void MaterAck(u8 lu8v_AckFlag)
{
	IIC_SDAC = OUTPUT;
	IIC_SCLC  = OUTPUT;
	
	delay5us();
	IIC_SDA = lu8v_AckFlag;
	delay5us();	
	IIC_SCL = 1;
	delay5us();	
	IIC_SCL = 0;
	delay5us();
}

/***********************************************************
**   Function : IIC_write_byte
**   INPUT    : lu8v_IIC_byte
**   OUTPUT   : none
**   NOTE     : 
**             SCL CqɡA~\SDAܤ			
***********************************************************/
void IIC_write_byte(u8 lu8v_IIC_byte)		
{
	 u8 i;
	
	IIC_SDAC = OUTPUT;							
	IIC_SCLC  = OUTPUT;
	
	IIC_SCL  = 0;					
	delay5us();	
	
	for(i=0;i<8;i++)				
	{
		if(lu8v_IIC_byte & 0x80) 
		{
			IIC_SDA = 1;
		}
		else
		{
		 	IIC_SDA = 0;	
		}	
					
		lu8v_IIC_byte = lu8v_IIC_byte << 1;
	//  Cʤ@ٮĲv
		delay5us();
		IIC_SCL  = 1;					
		delay5us();delay5us();
		IIC_SCL  = 0;					
		delay5us();
	}					
}

/***********************************************************
**   Function : IIC_read_byte
**   INPUT    : none
**   OUTPUT   : lu8v_IIC_byte
**   NOTE     : 
**             SCL CqɡA~\SDAܤ			
***********************************************************/
u8 IIC_read_byte()     				
{
	
	 u8 i,lu8v_IIC_byte=0;
	
	// IIC_SDA_PU = EN_high;
	IIC_SDAC   = INPUT;
	
	IIC_SCL  = 0;		
	delay5us();	
				
	for(i = 0; i < 8; i ++)			
	{	
				
		lu8v_IIC_byte = (lu8v_IIC_byte << 1) | IIC_SDA;		
		
		IIC_SCL  = 1;					
		delay5us(); delay5us(); 
		IIC_SCL  = 0 ;					
		//delay5us(); 	
				
	}
	// IIC_SDA_PU = 0;	
									
	return lu8v_IIC_byte;
}

/***********************************************************
**   Function : IIC_WriteData
**   INPUT    : lu8v_IIC_add,lu8v_IIC_data
**   OUTPUT   : none
**   NOTE     : 
**            	
***********************************************************/

void IIC_WriteData(u8 lu8v_IIC_add,u8 lu8v_IIC_data)
{
     u8 lu8v_IIC_ACK = 0;
	IIC_start();
	IIC_write_byte(IIC_Device_ADD);
	lu8v_IIC_ACK = IIC_respons();
	if(lu8v_IIC_ACK)
	{
		lu8v_IIC_ACK = 0;

		IIC_write_byte(lu8v_IIC_add);	
		lu8v_IIC_ACK = IIC_respons();

		if(lu8v_IIC_ACK)
		{
			IIC_write_byte(lu8v_IIC_data);
		}
		IIC_respons();
	}
	IIC_stop();
}

/***********************************************************
**   Function : IIC_ReadData
**   INPUT    : lu8v_IIC_add
**   OUTPUT   : lu8v_IIC_ReadData
**   NOTE     : 
**            	
***********************************************************/
u8 IIC_ReadData(u8 lu8v_IIC_add)
{
     u8 lu8v_IIC_ACK = 0;
     u8 lu8v_IIC_ReadData=0;
    
	IIC_start();
	IIC_write_byte(IIC_Device_ADD);
	lu8v_IIC_ACK = IIC_respons();
	if(lu8v_IIC_ACK)
	{
		IIC_write_byte(lu8v_IIC_add);		
	}
	lu8v_IIC_ACK = IIC_respons();
	if(lu8v_IIC_ACK)
	{	
		IIC_start();
		IIC_write_byte(IIC_Device_ADD|0x01);
		lu8v_IIC_ACK = IIC_respons();
		if(lu8v_IIC_ACK)
		{
			lu8v_IIC_ReadData = IIC_read_byte();		
		}
		MaterAck(M_NOACK);	 //ɵoe@ӤTH		
	}
	IIC_stop();

	return lu8v_IIC_ReadData;

}
